IF OBJECT_ID('P_RC_PGTO_PDV_DELETAR') IS NOT NULL
    BEGIN
	   DROP PROCEDURE P_RC_PGTO_PDV_DELETAR;
    END;
GO

CREATE PROCEDURE P_RC_PGTO_PDV_DELETAR (@CD_CTR_PGTO INT, @SOMENTEDELETA INT = NULL)
AS
DECLARE @CD_CTR INT
DECLARE @CD_EMP INT, 
		@CD_FILIAL INT,
		@CD_RC_DEB INT
SET NOCOUNT ON;
IF @CD_CTR_PGTO>0
BEGIN
	PRINT 'Cancelando a NCC'
	UPDATE
		PDV_VD_DEV_NCC
	SET 
		PDV_VD_DEV_NCC.STS_NCC=3,
		PDV_VD_DEV_NCC.HIST_AUDITORIA='NCC de tentativa de baixa gerada indevida'
	FROM
		RC_CREDIARIO_PARC_PDV_VD_DEV_NCC INNER JOIN PDV_VD_DEV_NCC ON
		RC_CREDIARIO_PARC_PDV_VD_DEV_NCC.CD_CTR_NCC =PDV_VD_DEV_NCC.CD_CTR_NCC 
	WHERE
		CD_CTR_PGTO =@CD_CTR_PGTO

	PRINT 'Analisando parcelas do crediario'
	DECLARE CAnaliseSaldoParcelCred CURSOR FAST_FORWARD FOR 
											SELECT
												CD_CTR
											FROM
												RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED 
											WHERE
												CD_CTR_PGTO=@CD_CTR_PGTO

	OPEN CAnaliseSaldoParcelCred
	FETCH NEXT FROM CAnaliseSaldoParcelCred INTO 
						@CD_CTR
		WHILE @@FETCH_STATUS = 0 
			BEGIN	
				PRINT 'Apagando bancario da parcela baixa'
				DELETE FROM RC_CREDIARIO_PARC_CRED_BC_LANC WHERE CD_CTR=@CD_CTR
				
				PRINT 'Apagando o bancario'
				DELETE 
					BC_LANC 
				FROM 
					BC_LANC INNER JOIN RC_CREDIARIO_PARC_CRED_BC_LANC ON
					BC_LANC.CD_EMP = RC_CREDIARIO_PARC_CRED_BC_LANC.CD_EMP AND
					BC_LANC.CD_BC_LANC = RC_CREDIARIO_PARC_CRED_BC_LANC.CD_BC_LANC 
				WHERE 
					RC_CREDIARIO_PARC_CRED_BC_LANC.CD_CTR=@CD_CTR
				
				PRINT 'Revendo saldo da parcela do crediario'
				EXEC P_ATUALIZA_SALDO_RC_CREDIARIO_PARC @CD_CTR
				
				DELETE FROM RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED WHERE CD_CTR=@CD_CTR
				
				DELETE FROM RC_CREDIARIO_PARC_CRED WHERE CD_CTR=@CD_CTR
				
				FETCH NEXT FROM CAnaliseSaldoParcelCred INTO 
						@CD_CTR
			END
		CLOSE CAnaliseSaldoParcelCred
		DEALLOCATE CAnaliseSaldoParcelCred

		PRINT 'Apagando bancario da duplicata'

		
		DELETE 
			RC_CRED_BC_LANC 
		FROM
			RC_PGTO_PDV_RC_CRED INNER JOIN RC_CRED_BC_LANC ON
			RC_PGTO_PDV_RC_CRED.CD_EMP = RC_CRED_BC_LANC.CD_EMP AND
			RC_PGTO_PDV_RC_CRED.CD_FILIAL = RC_CRED_BC_LANC.CD_FILIAL AND
			RC_PGTO_PDV_RC_CRED.CD_RC_DEB = RC_CRED_BC_LANC.CD_RC_DEB AND
			RC_PGTO_PDV_RC_CRED.CD_DP_LANC = RC_CRED_BC_LANC.CD_DP_LANC
		WHERE
			RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO=@CD_CTR_PGTO

		PRINT 'Apagando o bancario'
		DELETE 
			BC_LANC 
		FROM
			RC_PGTO_PDV_RC_CRED INNER JOIN RC_CRED_BC_LANC ON
			RC_PGTO_PDV_RC_CRED.CD_EMP = RC_CRED_BC_LANC.CD_EMP AND
			RC_PGTO_PDV_RC_CRED.CD_FILIAL = RC_CRED_BC_LANC.CD_FILIAL AND
			RC_PGTO_PDV_RC_CRED.CD_RC_DEB = RC_CRED_BC_LANC.CD_RC_DEB AND
			RC_PGTO_PDV_RC_CRED.CD_DP_LANC = RC_CRED_BC_LANC.CD_DP_LANC
			INNER JOIN BC_LANC ON
			RC_CRED_BC_LANC.CD_EMP = BC_LANC.CD_EMP AND
			RC_CRED_BC_LANC.CD_BC_LANC = BC_LANC.CD_BC_LANC 
		WHERE
			RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO=@CD_CTR_PGTO

		PRINT 'Apagando credito na duplicata do contas a receber'
		DELETE 
			RC_CRED 
		FROM
			RC_PGTO_PDV_RC_CRED INNER JOIN RC_CRED ON
			RC_PGTO_PDV_RC_CRED.CD_EMP = RC_CRED.CD_EMP AND
			RC_PGTO_PDV_RC_CRED.CD_FILIAL = RC_CRED.CD_FILIAL AND
			RC_PGTO_PDV_RC_CRED.CD_RC_DEB = RC_CRED.CD_RC_DEB AND
			RC_PGTO_PDV_RC_CRED.CD_DP_LANC = RC_CRED.CD_DP_LANC
		WHERE
			RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO=@CD_CTR_PGTO

		PRINT 'Revendo saldo de duplicata'			 
		DECLARE CAnaliseSaldoDuplicata CURSOR FAST_FORWARD FOR 
												SELECT
													CD_EMP,
													CD_FILIAL,
													CD_RC_DEB
												FROM
													RC_PGTO_PDV_RC_CRED 
												WHERE
													CD_CTR_PGTO=@CD_CTR_PGTO

		OPEN CAnaliseSaldoDuplicata
		FETCH NEXT FROM CAnaliseSaldoDuplicata INTO 
						@CD_EMP,@CD_FILIAL,@CD_RC_DEB
		WHILE @@FETCH_STATUS = 0 
			BEGIN	
				PRINT 'Refazendo saldo da duplicata'
				EXEC P_RC_DEB_ANALISE_SALDOS @CD_EMP,@CD_FILIAL,@CD_RC_DEB

				FETCH NEXT FROM CAnaliseSaldoDuplicata INTO 
						@CD_EMP,@CD_FILIAL,@CD_RC_DEB
			END
			CLOSE CAnaliseSaldoDuplicata
			DEALLOCATE CAnaliseSaldoDuplicata
		
		PRINT 'Apagando duplicata'
		DELETE 
		FROM
			RC_PGTO_PDV_RC_CRED 
		WHERE
			RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO=@CD_CTR_PGTO

	PRINT 'Apagando itens pagos'
	DELETE
	FROM
		RC_PGTO_PDV_ITENS_PAGOS
	WHERE
		CD_CTR_PGTO=@CD_CTR_PGTO
	
	PRINT 'Deletando pendencia de consolidacao'
	DELETE
		PDV_CONSLD_VD_CUPOM_PENDENCIA
	FROM
		PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV INNER JOIN RC_PGTO_PDV ON
		PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO
		INNER JOIN PDV_CUPOM_NAO_FISCAL ON
		PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND
		PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND
		PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR 
		INNER JOIN PDV_CONSLD_VD_CUPOM_PENDENCIA ON
		PDV_CUPOM_NAO_FISCAL.CD_EMP = PDV_CONSLD_VD_CUPOM_PENDENCIA.CD_EMP AND
		PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CONSLD_VD_CUPOM_PENDENCIA.CD_FILIAL AND
		PDV_CUPOM_NAO_FISCAL.NR_COO  = PDV_CONSLD_VD_CUPOM_PENDENCIA.NR_ECF AND 
		PDV_CUPOM_NAO_FISCAL.CD_CX  = PDV_CONSLD_VD_CUPOM_PENDENCIA.CD_CX AND 
		PDV_CUPOM_NAO_FISCAL.DT_CUPOM  = PDV_CONSLD_VD_CUPOM_PENDENCIA.DT_VD 
	WHERE
		PDV_CONSLD_VD_CUPOM_PENDENCIA.TP_CUPOM =1


	DECLARE @CD_CTR_CUPOM_N INT
	
	BEGIN TRY

		PRINT 'Analisando parcelas do crediario'
		DECLARE CChqs CURSOR FAST_FORWARD FOR 
												SELECT
													CD_CTR
												FROM
													PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV 
												WHERE
													CD_CTR_PGTO=@CD_CTR_PGTO

		OPEN CChqs
		FETCH NEXT FROM CChqs INTO 
							@CD_CTR_CUPOM_N
			WHILE @@FETCH_STATUS = 0 
				BEGIN	
					PRINT 'Apagando os registros'

					DECLARE @ANO2 INT
					DECLARE @CD_CHQ_LANC2 INT
					DECLARE @CD_CHQ2 INT
					DECLARE @CD_FILIAL2 INT
					
					DECLARE CChqs2 CURSOR FAST_FORWARD FOR 
												SELECT
													ANO, CD_CHQ_LANC, CD_CHQ, CD_FILIAL
												FROM
													PDV_CUPOM_NAO_FISCAL_CHQS_CHQ_LANC 
												WHERE
													CD_CTR = @CD_CTR_CUPOM_N

					OPEN CChqs2
					FETCH NEXT FROM CChqs2 INTO 
										@ANO2, @CD_CHQ_LANC2, @CD_CHQ2, @CD_FILIAL2 
						WHILE @@FETCH_STATUS = 0 
							BEGIN	
								PRINT 'Apagando os registros 2'
								

								DELETE FROM CHQ_LANC_CHQ_LANC_CPL WHERE CD_EMP = 1 AND ANO = @ANO2 AND CD_CHQ_LANC = @CD_CHQ_LANC2 AND CD_CHQ = @CD_CHQ2	
								
								DELETE FROM CHQ_LANC_CPL WHERE CD_EMP = 1 AND CD_CHQ = @CD_CHQ2

								DELETE FROM CHQ_LANC WHERE CD_EMP = 1 AND ANO = @ANO2 AND CD_CHQ_LANC = @CD_CHQ_LANC2
			
								FETCH NEXT FROM CChqs2 INTO 
										@ANO2, @CD_CHQ_LANC2, @CD_CHQ2, @CD_FILIAL2
							END
					CLOSE CChqs2
					DEALLOCATE CChqs2

					DELETE FROM PDV_CUPOM_NAO_FISCAL_CHQS_CHQ_LANC
					WHERE CD_CTR = @CD_CTR_CUPOM_N
					
					DELETE FROM PDV_CUPOM_NAO_FISCAL_CHQS
					WHERE CD_CTR = @CD_CTR_CUPOM_N
					
					DELETE FROM PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV WHERE CD_CTR_PGTO = @CD_CTR_PGTO
			
					FETCH NEXT FROM CChqs INTO 
							@CD_CTR_CUPOM_N
				END
		CLOSE CChqs
		DEALLOCATE CChqs
	END TRY
	BEGIN CATCH 
		PRINT 'Erro na deleo dos cheques'
	END CATCH


	IF ISNULL(@SomenteDeleta,0) = 0
	BEGIN

		PRINT 'Criando pendencia de consolidacao'
		INSERT INTO PDV_CONSLD_VD_CUPOM_PENDENCIA
		 (CD_EMP,
		 CD_FILIAL,
		 DT_VD,
		 NR_ECF,
		 CD_CX,
		 CD_USU,
		 DT_CAD,
		 TP_CUPOM)
		 SELECT
			PDV_CUPOM_NAO_FISCAL.CD_EMP,
			PDV_CUPOM_NAO_FISCAL.CD_FILIAL,
			PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
			PDV_CUPOM_NAO_FISCAL.NR_COO,
			PDV_CUPOM_NAO_FISCAL.CD_CX,
			1,
			GETDATE(),
			1
		FROM
			PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV INNER JOIN RC_PGTO_PDV ON
			PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO
			INNER JOIN PDV_CUPOM_NAO_FISCAL ON
			PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND
			PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND
			PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR 
		WHERE
			PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = @CD_CTR_PGTO
		
		PRINT 'Apagando cupom nao fiscal vinculo pagamento'
		DELETE FROM 
			PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV
		WHERE
			CD_CTR_PGTO=@CD_CTR_PGTO

		PRINT 'Apagando cupom nao fiscal vinculo com ncc de baixa de parcela de fatura'
		DELETE 
			RC_CREDIARIO_PARC_PDV_VD_DEV_NCC
		WHERE
			CD_CTR_PGTO=@CD_CTR_PGTO
		PRINT 'Apagando cupom nao fiscal vinculo com ncc de baixa de duplicata'
		DELETE 
			RC_DEB_PDV_VD_DEV_NCC
		WHERE
			CD_CTR_PGTO=@CD_CTR_PGTO


		PRINT 'Apagando pagamento'
		DELETE
		FROM
			RC_PGTO_PDV
		WHERE
			CD_CTR_PGTO=@CD_CTR_PGTO
	END
END
